*-------------------------------------------------------------------------------
*						Appendix IV Fig 6
*-------------------------------------------------------------------------------

** Set Path
global Raw_data    	"G:\project-finished\Descriptive\Data"
global App_data    	"G:\project-finished\Descriptive\Appendix Data"
global Class_data   "G:\project-finished\Descriptive\Classification"  
global Work_lab   	"G:\project-finished\Descriptive\Lab"
global Out_lab    	"G:\project-finished\Descriptive\Out" 

cd "$Work_lab"
                            
capture log close            
log using "$Out_lab\Appendix IV Fig 6", replace 
set more off     


**------------------------------------------------------------------------------
* Step1: Generate Data
**------------------------------------------------------------------------------
clear
set obs 0
save plotdata,replace emptyok

foreach j in "2000" "2010" "2015" {
use "`j'census_consistent.dta",clear

*Define edu group
	if `j'==2000{
	tostring educ,gen(edu_level) 

	gen edu=1 if edu_level=="1"|edu_level=="2"|edu_level=="3"|edu_level=="4" 
	replace edu=2 if edu_level=="5" |edu_level=="6"
	replace edu=3 if edu_level=="7" |edu_level=="8" | edu_level=="9"
	}

	if `j'==2010{
	tostring _受教育程度,gen(edu_level) 
	
	gen edu=1 if edu_level=="1"|edu_level=="2"|edu_level=="3"
	replace edu=2 if edu_level=="4" 
	replace edu=3 if edu_level=="5" |edu_level=="6" | edu_level=="7"
	}

	if `j'==2015{
	gen edu=1 if edu_level=="1"|edu_level=="2"|edu_level=="3"
	replace edu=2 if edu_level=="4" |edu_level=="5"
	replace edu=3 if edu_level=="6" |edu_level=="7" | edu_level=="8"
	}

gen id_new=_n
rename edu group

collapse (count) id_new,by(group consistent title_consistent)

bys group:egen temp=total(id_new)
gen occ_share=(id_new/temp)*100
drop temp id_new
compress
gen year=`j'

append using plotdata
save plotdata,replace
}


**------------------------------------------------------------------------------
* Step1: Plot Data
**------------------------------------------------------------------------------
gen edu="low" if group==1
replace edu="medium" if group==2
replace edu="high" if group==3

reshape wide occ_share,i(consistent title_consistent edu group) j(year)
gsort group -occ_share2000

by group:gen rank=_n
keep if rank<=15

replace title_consistent="交通运输和设备操作员" if title_consistent=="轨道交通运输机械设备操作及有关人员"
replace title_consistent="纺织和服装剪裁员" if title_consistent=="纺织品和服装剪裁缝纫人员"
replace title_consistent="检测计量员" if title_consistent=="检验、检测和计量服务人员"


foreach i in "low" "medium" "high"{
graph bar occ_share2000 occ_share2010 occ_share2015 if edu=="`i'", over(title_consistent,sort(rank) gap(120)) ///
horizontal scheme(plotplain) legend(label(1 "2000") label(2 "2010") label(3 "2015") position(6) rows(1)) ///
xsize(4) ysize(6) blabel(bar,format(%9.1f) size(2))
graph save "$Out_lab\appIV_Fig6_`i'",replace
graph export "$Out_lab\appIV_Fig6_`i'.png",replace

}


erase plotdata.dta

log close
